set sql_safe_updates=0;
SET @dataproviderId3=(SELECT id FROM dydt_data_provider WHERE `providerName`='Student Mother Info');
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT 
    per_mother.firstName AS mother_first_name,
    per_mother.lastName AS mother_last_name,
    per_mother.mobileCountryCode AS mother_mobile_country_code,
    per_mother.mobileNumber AS mother_mobile_no,
    per_mother.middleName AS mother_middle_name,
    per_mother.firstNameOtherLanguage AS mother_first_name_otherLang,
    per_mother.middleNameOtherLanguage AS mother_middle_name_otherLang,
    per_mother.lastNameOtherLanguage AS mother_last_name_otherLang
FROM
    students st
        INNER JOIN
    persons per ON st.personId = per.id
        INNER JOIN
    person_relationships per_rel ON per.id = per_rel.personId
        AND per_rel.relationship = "MOTHER"
        INNER JOIN
    persons per_mother ON per_rel.relatedPersonId = per_mother.id',
    `resultColumnsDef` = 'mother_first_name,mother_last_name,mother_mobile_no,mother_mobile_country_code,mother_middle_name,mother_first_name_otherLang,mother_middle_name_otherLang,mother_last_name_otherLang'
WHERE
    `dataSourceCode` = 'Student Mothers Info' AND dataProviderId = @dataproviderId3;
set sql_safe_updates=1;

#------------------TRANSLATIONS---------------------

SET @dydtdatalinitemId=(SELECT id FROM `dydt_data_line_item` where dataSourceCode='Student Mothers Info');
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('mother_first_name', 'Mother First Name',@dydtdatalinitemId),
    ('mother_mobile_no', 'Mother Mobile Number',@dydtdatalinitemId),
    ('mother_last_name', 'Mother Last Name',@dydtdatalinitemId),
    ('mother_mobile_country_code', 'Mother Mobile Country Code',@dydtdatalinitemId),
    ('mother_middle_name', 'Mother Middle Name',@dydtdatalinitemId),
    ('mother_first_name_otherLang', 'Mother First Name Other Language',@dydtdatalinitemId),
    ('mother_middle_name_otherLang', 'Mother Middle Name Other Language',@dydtdatalinitemId),
    ('mother_last_name_otherLang', 'Mother Last Name Other Language',@dydtdatalinitemId);